<?php

/**
 * StatusPage Shortcodes.
 *
 * Registers shortcodes for embedding status widgets.
 *
 * @package StatusPageWidget
 */

// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Class StatusPage_Shortcodes
 *
 * Handles shortcode registration and rendering.
 */
class StatusPage_Shortcodes
{

    /**
     * Initialize shortcodes.
     */
    public static function init()
    {
        add_shortcode('statuspage_widget', array(__CLASS__, 'render_widget_shortcode'));
        add_shortcode('statuspage_badge', array(__CLASS__, 'render_badge_shortcode'));
    }

    /**
     * Render the statuspage_widget shortcode.
     *
     * Usage: [statuspage_widget slug="your-slug" theme="dark" compact="1" show_incidents="1"]
     *
     * @param array $atts Shortcode attributes.
     * @return string Rendered HTML.
     */
    public static function render_widget_shortcode($atts)
    {
        // Get defaults from settings.
        $defaults = StatusPage_Settings::get_defaults();

        $atts = shortcode_atts(
            array(
                'slug'           => $defaults['slug'],
                'theme'          => $defaults['theme'],
                'compact'        => $defaults['compact'] ? '1' : '0',
                'show_incidents' => $defaults['show_incidents'] ? '1' : '0',
                'rtm'            => (string) $defaults['rtm'],
                'upd'            => (string) $defaults['upd'],
                'refresh'        => (string) $defaults['refresh'],
                'disable_link'   => $defaults['disable_link'] ? '1' : '0',
                'render_mode'    => $defaults['render_mode'],
            ),
            $atts,
            'statuspage_widget'
        );

        // Convert string values to proper types.
        $render_atts = array(
            'slug'           => $atts['slug'],
            'theme'          => $atts['theme'],
            'compact'        => in_array($atts['compact'], array('1', 'true', 'yes'), true),
            'show_incidents' => in_array($atts['show_incidents'], array('1', 'true', 'yes'), true),
            'rtm'            => absint($atts['rtm']),
            'upd'            => absint($atts['upd']),
            'disable_link'   => in_array($atts['disable_link'], array('1', 'true', 'yes'), true),
            'render_mode'    => $atts['render_mode'],
        );

        return StatusPage_Renderer::render($render_atts);
    }

    /**
     * Render the statuspage_badge shortcode.
     *
     * Usage: [statuspage_badge slug="your-slug" link="1" alt="Service Status"]
     *
     * @param array $atts Shortcode attributes.
     * @return string Rendered HTML.
     */
    public static function render_badge_shortcode($atts)
    {
        // Get default slug from settings.
        $defaults = StatusPage_Settings::get_defaults();

        $atts = shortcode_atts(
            array(
                'slug' => $defaults['slug'],
                'link' => '1',
                'alt'  => '',
            ),
            $atts,
            'statuspage_badge'
        );

        $link = ! in_array($atts['link'], array('0', 'false', 'no'), true);

        return StatusPage_Renderer::render_badge($atts['slug'], $link, $atts['alt']);
    }
}
